/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedBlockStateWater
extends BlockStateContainer {
    private final ImmutableSet<IUnlistedProperty<?>> unlistedProperties;

    public ExtendedBlockStateWater(Block blockIn, IProperty<?>[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, properties, ExtendedBlockStateWater.buildUnlistedMap(unlistedProperties));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IUnlistedProperty<?> property : unlistedProperties) {
            builder.add(property);
        }
        this.unlistedProperties = builder.build();
    }

    public Collection<IUnlistedProperty<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    private static ImmutableMap<IUnlistedProperty<?>, Optional<?>> buildUnlistedMap(IUnlistedProperty<?>[] unlistedProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IUnlistedProperty<?> p : unlistedProperties) {
            builder.put(p, Optional.empty());
        }
        return builder.build();
    }

    @Nonnull
    protected BlockStateContainer.StateImplementation createState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        if (unlistedProperties == null || unlistedProperties.isEmpty()) {
            return super.createState(block, properties, unlistedProperties);
        }
        return new ExtendedStateImplementationWater(block, properties, unlistedProperties, null, null);
    }

    protected static class ExtendedStateImplementationWater
    extends BlockStateContainer.StateImplementation
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private final IBlockState cleanState;

        protected ExtendedStateImplementationWater(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> table, IBlockState clean) {
            super(block, properties, table);
            this.unlistedProperties = unlistedProperties;
            this.cleanState = clean == null ? this : clean;
        }

        @Nonnull
        public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(@Nonnull IProperty<T> property, @Nonnull V value) {
            IBlockState clean = super.func_177226_a(property, value);
            if (clean == this.cleanState) {
                return this;
            }
            if (this == this.cleanState) {
                return clean;
            }
            return new ExtendedStateImplementationWater(this.func_177230_c(), clean.func_177228_b(), this.unlistedProperties, ((BlockStateContainer.StateImplementation)clean).getPropertyValueTable(), this.cleanState);
        }

        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, @Nullable V value) {
            Optional oldValue = (Optional)this.unlistedProperties.get(property);
            if (oldValue == null) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
            }
            if (Objects.equals(oldValue.orElse(null), value)) {
                return this;
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
            }
            boolean clean = true;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.unlistedProperties.entrySet()) {
                Optional newValue;
                IUnlistedProperty key = (IUnlistedProperty)entry.getKey();
                Optional optional = newValue = key.equals(property) ? Optional.ofNullable(value) : (Optional)entry.getValue();
                if (newValue.isPresent()) {
                    clean = false;
                }
                builder.put((Object)key, (Object)newValue);
            }
            if (clean) {
                return (IExtendedBlockState)this.cleanState;
            }
            return new ExtendedStateImplementationWater(this.func_177230_c(), this.func_177228_b(), builder.build(), this.field_177238_c, this.cleanState);
        }

        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return this.unlistedProperties.keySet();
        }

        public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
            if (property == BlockLiquid.field_176367_b) {
                return (T)((Comparable)property.func_177699_b().cast(15));
            }
            return (T)super.func_177229_b(property);
        }

        @Nullable
        public <V> V getValue(IUnlistedProperty<V> property) {
            Optional value = (Optional)this.unlistedProperties.get(property);
            if (value == null) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
            }
            return (V)property.getType().cast(value.orElse(null));
        }

        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        public IBlockState getClean() {
            return this.cleanState;
        }
    }
}

